//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "PwmUseCasePage.h"

@interface PwmUseCasePage ()
@end

@implementation PwmUseCasePage

int realResolutionChannel0;
int realResolutionChannel1;

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initViewUIElements];
}

- (IBAction)setI2cSlaveModeOptionSelected:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CSlave:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)setI2cMasterModeOptionSelected:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CMaster:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)setGPIOPWMModeOptionSelected:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setGPIOPWM:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)getUseCaseCongifOptionSelected:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] getUseCaseConfig:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)writeConfigButtonClick:(UIButton *)sender {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        ISO15693Command *pwmConfigCommand = [self getPWMConfigCommand];
        ISO15693Command *pwm0cmd = [self getPWM0Command];
        ISO15693Command *pwm1cmd = [self getPWM1Command];
        
        [[PWMUseCase sharedInstance] writePWM:pwmConfigCommand pwm0Command:pwm0cmd pwm1Command:pwm1cmd onSuccess:^(NSData *aData){

            [self writeLog:pwm1cmd.getNSStringCommand response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)readConfigButtonClick:(UIButton *)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[PWMUseCase sharedInstance] readPWM:^(NSData * aData, const int order) {
            
            if (order == 0){
                [self writeLog:cmd_readGPIOPWMConfig response:aData];
                [self updateUIWithPWMConfig:aData];
                
            } else if (order == 1){
                [self writeLog:cmd_readPWM0Reg response:aData];
                [self updateUIWithPWMDutyCycle0:aData];
                
            } else if (order == 2){
                [self writeLog:cmd_readPWM1Reg response:aData];
                [self updateUIWithPWMDutyCycle1:aData];
            }
            
        } onFailure:^(NSError * _Nonnull error) {
            NSLog(@"Read PWM Error!");
            [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (void) updateUIWithPWMConfig: (NSData *) response{
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        const char *pwmConfigBytes = [response bytes];
        
        if ((pwmConfigBytes[1] & 0xC0) == 0x00)
            self->_prescalarConfigCh1DropDownTitle.text = str_00b;
        else if ((pwmConfigBytes[1] & 0xC0) == 0x40)
            self->_prescalarConfigCh1DropDownTitle.text = str_01b;
        
        else if ((pwmConfigBytes[1] & 0xC0) == 0x80)
            self->_prescalarConfigCh1DropDownTitle.text = str_10b;
        
        else if ((pwmConfigBytes[1] & 0xC0) == 0xC0)
            self->_prescalarConfigCh1DropDownTitle.text = str_11b;
        
        if ((pwmConfigBytes[1] & 0x30) == 0x00)
            self->_prescalarConfigCh0DropDownTitle.text = str_00b;
        
        else if ((pwmConfigBytes[1] & 0x30) == 0x10)
            self->_prescalarConfigCh0DropDownTitle.text = str_01b;
        
        else if ((pwmConfigBytes[1] & 0x30) == 0x20)
            self->_prescalarConfigCh0DropDownTitle.text = str_10b;
        
        else if ((pwmConfigBytes[1] & 0x30) == 0x30)
            self->_prescalarConfigCh0DropDownTitle.text = str_11b;
        
        if ((pwmConfigBytes[1] & 0x0C) == 0x00){
            self->_resolutionCh1DropDownTitle.text = str_6_bit;
            realResolutionChannel1 = 6;
            
        }else if ((pwmConfigBytes[1] & 0x0C) == 0x04){
            self->_resolutionCh1DropDownTitle.text = str_8_bit;
            realResolutionChannel1 = 8;
            
        }else if ((pwmConfigBytes[1] & 0x0C) == 0x08){
            self->_resolutionCh1DropDownTitle.text = str_10_bit;
            realResolutionChannel1 = 10;
            
        }else if ((pwmConfigBytes[1] & 0x0C) == 0x0C){
            self->_resolutionCh1DropDownTitle.text = str_12_bit;
            realResolutionChannel1 = 12;
        }
        
        if ((pwmConfigBytes[1] & 0x03) == 0x00){
            self->_resolutionCh0DropDownTitle.text = str_6_bit;
            realResolutionChannel0 = 6;
            
        }else if ((pwmConfigBytes[1] & 0x03) == 0x01){
            self->_resolutionCh0DropDownTitle.text = str_8_bit;
            realResolutionChannel0 = 8;
            
        }else if ((pwmConfigBytes[1] & 0x03) == 0x02){
            self->_resolutionCh0DropDownTitle.text = str_10_bit;
            realResolutionChannel0 = 10;
            
        }else if ((pwmConfigBytes[1] & 0x03) == 0x03){
            self->_resolutionCh0DropDownTitle.text = str_12_bit;
            realResolutionChannel0 = 12;
        }
    }];
}

- (void) updateUIWithPWMDutyCycle0: (NSData *) response{
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        
        //For a better understanding of the parsing of PWM Start time and duty cycle it is needed to
        //check the product datasheet, in the PWM section you can find an example of PWM configuration.
        
        unsigned char * pwm0DutyCycle_bytes = (unsigned char *)[response bytes];
        //Swap bytes of the configuration (MSB first) for further operations.
        
        int tmp_pwm0_on1 = pwm0DutyCycle_bytes[1];
        int tmp_pwm0_on2 = pwm0DutyCycle_bytes[0];
        
        int tmp_pwm0_off1 = pwm0DutyCycle_bytes[3];
        int tmp_pwm0_off2 = pwm0DutyCycle_bytes[2];
        
        int num_pwm0_on = tmp_pwm0_on2;
        int num_pwm0_off = tmp_pwm0_off2;
        
        int start_time0 = ceil ( (tmp_pwm0_on2) / (pow(2, realResolutionChannel0)) *100 );
        
        num_pwm0_off -= num_pwm0_on;
        
        int dutyCycle0 = ceil ( (num_pwm0_off) / pow(2, realResolutionChannel0) *100 );
        
        [self-> _startTimeCh0Slider setValue:start_time0];
        [self-> _dutyCycleCh0Slider setValue:dutyCycle0];
        [self StartTimeChannel0_ValueListener:self->_startTimeCh0Slider];
    }];
}

- (void) updateUIWithPWMDutyCycle1: (NSData *) response{
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        
        //For a better understanding of the parsing of PWM Start time and duty cycle it is needed to
        //check the product datasheet, in the PWM section you can find an example of PWM configuration.
        
        unsigned char * pwm1DutyCycle_bytes = (unsigned char *)[response bytes];
        //Swap bytes of the configuration (MSB first) for further operations.
        
        int tmp_pwm1_on1 = pwm1DutyCycle_bytes[1];
        int tmp_pwm1_on2 = pwm1DutyCycle_bytes[0];
        
        int tmp_pwm1_off1 = pwm1DutyCycle_bytes[3];
        int tmp_pwm1_off2 = pwm1DutyCycle_bytes[2];
        
        int num_pwm1_on = tmp_pwm1_on2;
        int num_pwm1_off = tmp_pwm1_off2;
        
        int start_time1 = ceil ( (tmp_pwm1_on2) / (pow(2, realResolutionChannel0)) *100 );
        
        num_pwm1_off -= num_pwm1_on;
        
        int dutyCycle1 = ceil ( (num_pwm1_off) / pow(2, realResolutionChannel0) *100 );
        [self-> _startTimeCh1Slider setValue:start_time1];
        [self-> _dutyCycleCh1Slider setValue:dutyCycle1];
        [self StartTimeChannel1_ValueListener:self->_startTimeCh1Slider];
    }];
}

- (ISO15693Command *) getPWMConfigCommand{
    ISO15693Command *pwmConfigCommand;
    char data []  = {0x03, 0x00, 0x00, 0x00};
    
    if (([self->_prescalarConfigCh0DropDownTitle.text       isEqual: str_00b]))
        data[1] |= 0x00;
    
    else if (([self->_prescalarConfigCh0DropDownTitle.text  isEqual: str_01b]))
        data[1] |= 0x10;
    
    else if (([self->_prescalarConfigCh0DropDownTitle.text  isEqual: str_10b]))
        data[1] |= 0x20;
    
    else if (([self->_prescalarConfigCh0DropDownTitle.text  isEqual: str_11b]))
        data[1] |= 0x30;
    
    if (([self->_prescalarConfigCh1DropDownTitle.text       isEqual: str_00b]))
        data[1] |= 0x00;
    
    else if (([self->_prescalarConfigCh1DropDownTitle.text  isEqual: str_01b]))
        data[1] |= 0x40;
    
    else if (([self->_prescalarConfigCh1DropDownTitle.text  isEqual: str_10b]))
        data[1] |= 0x80;
    
    else if (([self->_prescalarConfigCh1DropDownTitle.text  isEqual: str_11b]))
        data[1] |= 0xC0;
    
    if ([self->_resolutionCh0DropDownTitle.text             isEqual: str_6_bit])
        data[1] |= 0x00;
    
    else if ([self->_resolutionCh0DropDownTitle.text        isEqual: str_8_bit])
        data[1] |= 0x01;
    
    else if ([self->_resolutionCh0DropDownTitle.text        isEqual: str_10_bit])
        data[1] |= 0x02;
    
    else if ([self->_resolutionCh0DropDownTitle.text        isEqual: str_12_bit])
        data[1] |= 0x03;
    
    if ([self->_resolutionCh1DropDownTitle.text             isEqual: str_6_bit])
        data[1] |= 0x00;
    
    else if ([self->_resolutionCh1DropDownTitle.text        isEqual: str_8_bit])
        data[1] |= 0x04;
    
    else if ([self->_resolutionCh1DropDownTitle.text        isEqual: str_10_bit])
        data[1] |= 0x08;
    
    else if ([self->_resolutionCh1DropDownTitle.text        isEqual: str_12_bit])
        data[1] |= 0x0C;
    
    NSString *hexString = [Utils hexStringWithData:data ofLength:sizeof(data)];
    NSString *strCmd = [NSString stringWithFormat:@"%@%@", cmd_writePWMSession, hexString];
    pwmConfigCommand = [[ISO15693Command alloc]initWithData:strCmd];
    
    return pwmConfigCommand;
}

- (int) getResolutionCh0{
    int res = 6;
    if(([_resolutionCh0DropDownTitle.text                   isEqual: str_8_bit])){
        res = 8;
    } else if(([_resolutionCh0DropDownTitle.text            isEqual: str_10_bit])){
        res = 10;
    } else if(([_resolutionCh0DropDownTitle.text            isEqual: str_12_bit])){
        res = 12;
    }
    
    return res;
}

- (int) getResolutionCh1{
    int res = 6;
    if(([_resolutionCh1DropDownTitle.text                   isEqual: str_8_bit])){
        res = 8;
    } else if(([_resolutionCh1DropDownTitle.text            isEqual: str_10_bit])){
        res = 10;
    } else if(([_resolutionCh1DropDownTitle.text            isEqual: str_12_bit])){
        res = 12;
    }
    
    return res;
}

- (ISO15693Command *) getPWM0Command{
    ISO15693Command *pwmConfigCommand = [[ISO15693Command alloc] init];
    realResolutionChannel0 = [self getResolutionCh0];
    
    double pwm0_on          = ceil(pow(2, realResolutionChannel0 = realResolutionChannel0))*(_startTimeCh0Slider.value/100);
    double pwm0_off         = ceil(pow(2, realResolutionChannel0))*(_dutyCycleCh0Slider.value/100);

    pwm0_off += pwm0_on;
    signed char data [4]  = {pwm0_on + 1, 0x00, pwm0_off + 1, 0x00 };
    
    NSString *hexString = [Utils hexStringWithData:data ofLength:sizeof(data)];
    NSString *strCmd = [NSString stringWithFormat:@"%@%@", cmd_writePWM0Reg, hexString];
    pwmConfigCommand = [[ISO15693Command alloc]initWithData:strCmd];
    
    return pwmConfigCommand;
}

- (ISO15693Command *) getPWM1Command{
    ISO15693Command *pwmConfigCommand;
    realResolutionChannel1  = [self getResolutionCh1];
    
    double pwm1_on          = ceil(pow(2, realResolutionChannel1 = realResolutionChannel1))*(_startTimeCh1Slider.value/100);
    double pwm1_off         = ceil(pow(2, realResolutionChannel1))*(_dutyCycleCh1Slider.value/100);
    
    pwm1_off += pwm1_on;
    signed char data [4]    = { pwm1_on, 0x00, pwm1_off, 0x00 };
    
    NSString *hexString     = [Utils hexStringWithData:data ofLength:sizeof(data)];
    NSString *strCmd        = [NSString stringWithFormat:@"%@%@", cmd_writePWM1Reg, hexString];
    pwmConfigCommand        = [[ISO15693Command alloc]initWithData:strCmd];
    
    return pwmConfigCommand;
}

- (void)DoInitSession {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
}

- (IBAction)StartTimeChannel0_ValueListener:(id)sender {
    int val0 =  _startTimeCh0Slider.value;
    int val0_alt =  _startTimeCh0Slider.value;
    
    int valMax = 80;
    
    while(true){
        if(val0 > valMax)
            val0--;
        else{
            _startTimeCh0Slider.value = val0;
            break;
        }
    }
    
    while(true){
        if(val0 % 10 != 0)
            val0++;
        else
            break;
        
        if(val0_alt % 10 != 0)
            val0_alt--;
        else{
            val0 = val0_alt;
            break;
        }
    }
    
    int result = valMax - val0 + 10;
    [self UpdatePos0SlidersUIWithValueFromStartTime:result val0:val0];
}

- (IBAction)DutyCycle0_ValueListener:(id)sender {
    int val0 =  _dutyCycleCh0Slider.value;
    int val0_alt =  _dutyCycleCh0Slider.value;
    
    int valMax = 90;
    int valMin = 10;
    
    while(true){
        if(val0 > valMax)
            val0--;
        else{
            _dutyCycleCh0Slider.value = val0;
            break;
        }
    }
    
    while(true){
        if(val0 < valMin)
            val0++;
        else{
            _dutyCycleCh0Slider.value = val0;
            break;
        }
    }
    
    while(true){
        if(val0 % 10 != 0)
            val0++;
        else
            break;
        
        if(val0_alt % 10 != 0)
            val0_alt--;
        else{
            val0 = val0_alt;
            break;
        }
    }
    
    int result = valMax - val0;
    [self UpdatePos0SlidersUIWithValueFromDutyCycle:result val0:val0];
}

- (void)UpdatePos1SlidersUIWithValueFromStartTime:(int)result val0:(int)val0 {
    _dutyCycleCh1Slider.value       = result;
    _startTimeCh1Label.text         =  [NSString stringWithFormat:@"Start time: %d %%", val0];
    _dutyCycleCh1Label.text         =  [NSString stringWithFormat:@"Duty cycle: %d %%", result];
}

- (IBAction)StartTimeChannel1_ValueListener:(id)sender {
    int val0 =  ceil ( _startTimeCh1Slider.value);
    int val0_alt =  _startTimeCh1Slider.value;
    
    int valMax = 80;
    
    while(true){
        if(val0 > valMax)
            val0--;
        else{
            _startTimeCh1Slider.value = val0;
            break;
        }
    }
    
    while(true){
        if(val0 % 10 != 0)
            val0++;
        else
            break;
        
        if(val0_alt % 10 != 0)
            val0_alt--;
        else{
            val0 = val0_alt;
            break;
        }
    }
    
    int result = ceil( valMax - val0 +10);
    [self UpdatePos1SlidersUIWithValueFromStartTime:result val0:val0];
}

- (void)UpdatePos1SlidersUIWithValueFromDutyCycle:(int)result val0:(int)val0 {
    _startTimeCh1Slider.value       = result;
    _startTimeCh1Label.text         =  [NSString stringWithFormat:@"Start time: %d %%", result];
    _dutyCycleCh1Label.text         =  [NSString stringWithFormat:@"Duty cycle: %d %%", val0];
}

- (IBAction)DutyCycle1_ValueListener:(id)sender {
    int val0 =  ceil (_dutyCycleCh1Slider.value);
    int val0_alt =  _dutyCycleCh1Slider.value;
    
    int valMax = 90;
    int valMin = 10;
    
    while(true){
        if(val0 > valMax)
            val0--;
        else{
            _dutyCycleCh1Slider.value = val0;
            break;
        }
    }
    
    while(true){
        if(val0 < valMin)
            val0++;
        else{
            _dutyCycleCh1Slider.value = val0;
            break;
        }
    }
    
    while(true){
        if(val0 % 10 != 0)
            val0++;
        else
            break;
        
        if(val0_alt % 10 != 0)
            val0_alt--;
        else{
            val0 = val0_alt;
            break;
        }
    }
    
    int result = ceil( valMax - val0);
    [self UpdatePos1SlidersUIWithValueFromDutyCycle:result val0:val0];
}

/*---------------------- UI METHODS ----------------------*/

- (void) writeLog: (NSString *) cmd response: (NSData *) resp{
    NSMutableString * sbuf = [[Utils alloc] convertNSDataBytesToHexString:resp];
    
    NSString *log = [NSString stringWithFormat: @"NFC -> %@ \nTAG <- 00%@",
                     cmd, sbuf];
    
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        self-> _LogText.text = log;
        
        //Get the file path
        NSString *documentsDirectory = [NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];
        NSString *fileName = [documentsDirectory stringByAppendingPathComponent:@"PWMLogs.txt"];
        
        //create file if it doesn't exist
        if(![[NSFileManager defaultManager] fileExistsAtPath:fileName])
            [[NSFileManager defaultManager] createFileAtPath:fileName contents:nil attributes:nil];
        
        //append text to file (you'll probably want to add a newline every write)
        NSFileHandle *file = [NSFileHandle fileHandleForUpdatingAtPath:fileName];
        [file seekToEndOfFile];
        [file writeData:[log dataUsingEncoding:NSUTF8StringEncoding]];
        [file closeFile];
    }];
}

- (void)InitTimersForUI {
    [self->_dutyCycleCh0Slider setMinimumValue:0];
    [self->_dutyCycleCh1Slider setMinimumValue:0];
    
    [self->_dutyCycleCh0Slider setMaximumValue:100];
    [self->_dutyCycleCh1Slider setMaximumValue:100];
    
    [self->_startTimeCh0Slider setMaximumValue:100];
    [self->_startTimeCh1Slider setMaximumValue:100];
    
    [self->_startTimeCh0Slider setMinimumValue:0];
    [self->_startTimeCh1Slider setMinimumValue:0];
    
    [self StartTimeChannel1_ValueListener:self->_startTimeCh1Slider];
    [self StartTimeChannel0_ValueListener:self->_startTimeCh0Slider];
}

- (void)InitDropDownViews {
    _resolutionCh0DropdownList.userInteractionEnabled   = true;
    _resolutionCh0DropdownList.layer.borderColor        = [UIColor lightGrayColor].CGColor;
    _resolutionCh0DropdownList.layer.borderWidth        = 0.75;
    _resolutionCh0DropdownList.userInteractionEnabled   = true;
    _resolutionCh0DropdownList.userInteractionEnabled   = true;
    
    _prescalarCh0DropDownList.userInteractionEnabled    = true;
    _prescalarCh0DropDownList.layer.borderColor         = [UIColor lightGrayColor].CGColor;
    _prescalarCh0DropDownList.layer.borderWidth         = 0.75;
    _prescalarCh0DropDownList.userInteractionEnabled    = true;
    _prescalarCh0DropDownList.userInteractionEnabled    = true;
    
    _resolutionCh1DropdownList.userInteractionEnabled   = true;
    _resolutionCh1DropdownList.layer.borderColor        = [UIColor lightGrayColor].CGColor;
    _resolutionCh1DropdownList.layer.borderWidth        = 0.75;
    _resolutionCh1DropdownList.userInteractionEnabled   = true;
    _resolutionCh1DropdownList.userInteractionEnabled   = true;
    
    _prescalarCh1DropDownList.userInteractionEnabled    = true;
    _prescalarCh1DropDownList.layer.borderColor         = [UIColor lightGrayColor].CGColor;
    _prescalarCh1DropDownList.layer.borderWidth         = 0.75;
    _prescalarCh1DropDownList.userInteractionEnabled    = true;
    _prescalarCh1DropDownList.userInteractionEnabled    = true;
    
    _configDropDownList.userInteractionEnabled          = true;
    _configDropDownList.backgroundColor                 = UIColor.whiteColor;
    _configDropDownList.layer.borderColor               = [UIColor lightGrayColor].CGColor;
    _configDropDownList.layer.borderWidth               = 0.75;
    _configDropDownList.hidden                          = true;
}

- (void)InitButtonViews {
    _readConfigButton.layer.cornerRadius                = 8;
    _writeConfigButton.layer.cornerRadius               = 8;
    _readConfigButton.userInteractionEnabled            = true;
    _writeConfigButton.userInteractionEnabled           = true;
}

- (void)initViewUIElements {
    _scrollView.contentSize                             = CGSizeMake(self.view.frame.size.width, self.view.frame.size.height + 100);
    
    _channel0View.layer.cornerRadius                    = 8;
    _channel0View.layer.borderColor                     = [UIColor lightGrayColor].CGColor;
    _channel0View.layer.borderWidth                     = 0.75;
    _channel0View.backgroundColor                       = UIColor.whiteColor;
    
    _channel1View.layer.cornerRadius                    = 8;
    _channel1View.layer.borderColor                     = [UIColor lightGrayColor].CGColor;
    _channel1View.layer.borderWidth                     = 0.75;
    _channel1View.backgroundColor                       = UIColor.whiteColor;
    
    [self InitButtonViews];
    [self InitDropDownViews];
    [self setAutoHideDropDownMenuListener];
    [self InitTimersForUI];
}

- (void)UpdatePos0SlidersUIWithValueFromStartTime:(int)result val0:(int)val0 {
    _dutyCycleCh0Slider.value         = result;
    _startTimeCh0Label.text           =  [NSString stringWithFormat:@"Start time: %d %%", val0];
    _dutyCycleCh0Label.text           =  [NSString stringWithFormat:@"Duty cycle: %d %%", result];
}

- (void)UpdatePos0SlidersUIWithValueFromDutyCycle:(int)result val0:(int)val0 {
    _dutyCycleCh0Slider.value         = val0;
    _startTimeCh0Slider.value         = result;
    _startTimeCh0Label.text           =  [NSString stringWithFormat:@"Start time: %d %%", result];
    _dutyCycleCh0Label.text           =  [NSString stringWithFormat:@"Duty cycle: %d %%", val0];
}

- (CATransition *)StartAnimationTransition {
    CATransition *animation         = [CATransition animation];
    animation.type                  = kCATransitionReveal;
    animation.duration              = 0.1;
    return animation;
}

-(void)HideWhenTappedAnywhere{
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [_prescalarCh0DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh0DropDownList.hidden    = YES;
    
    [_prescalarCh1DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh1DropDownList.hidden    = YES;
    
    [_resolutionCh0DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh0DropdownList.hidden   = YES;
    
    [_resolutionCh1DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh1DropdownList.hidden   = YES;
}

- (void)setAutoHideDropDownMenuListener {
    UITapGestureRecognizer *singleTap   = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(HideWhenTappedAnywhere)];
    singleTap.numberOfTapsRequired = 1;
    
    [self.mainView setUserInteractionEnabled:YES];
    [self.mainView addGestureRecognizer:singleTap];
}

- (IBAction)resolutionCh0DropDownListTap:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [_prescalarCh0DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh0DropDownList.hidden    = YES;
    
    [_prescalarCh1DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh1DropDownList.hidden    = YES;
    
    [_resolutionCh0DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh0DropdownList.hidden   = NO;
    
    [_resolutionCh1DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh1DropdownList.hidden   = YES;
}

- (IBAction)resolutionCh06bitOptionSelected:(id)sender {
    _resolutionCh0DropDownTitle.text    = str_6_bit;
    _resolutionCh0DropdownList.hidden   = true;
}

- (IBAction)resolutionCh08bitOptionSelected:(id)sender {
    _resolutionCh0DropDownTitle.text    = str_8_bit;
    _resolutionCh0DropdownList.hidden   = true;
}

- (IBAction)resolutionCh010bitOptionSelected:(id)sender {
    _resolutionCh0DropDownTitle.text    = str_10_bit;
    _resolutionCh0DropdownList.hidden   = true;
}

- (IBAction)resolutionCh012bitOptionSelected:(id)sender {
    _resolutionCh0DropDownTitle.text      = str_12_bit;
    _resolutionCh0DropdownList.hidden     = true;
}

- (IBAction)prescaleCh000bitOptionSelected:(id)sender {
    _prescalarConfigCh0DropDownTitle.text = str_00b;
    _prescalarCh0DropDownList.hidden      = true;
}

- (IBAction)prescaleCh001bitOptionSelected:(id)sender {
    _prescalarConfigCh0DropDownTitle.text = str_01b;
    _prescalarCh0DropDownList.hidden      = true;
}

- (IBAction)prescaleCh010bitOptionSelected:(id)sender {
    _prescalarConfigCh0DropDownTitle.text = str_10b;
    _prescalarCh0DropDownList.hidden      = true;
}
- (IBAction)prescaleCh011bitOptionSelected:(id)sender {
    _prescalarConfigCh0DropDownTitle.text = str_11b;
    _prescalarCh0DropDownList.hidden      = true;
}

- (IBAction)prescalarCh0DropDownListTap:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [_prescalarCh0DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh0DropDownList.hidden    = NO;
    
    [_prescalarCh1DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh1DropDownList.hidden    = YES;
    
    [_resolutionCh0DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh0DropdownList.hidden   = YES;
    
    [_resolutionCh1DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh1DropdownList.hidden   = YES;
}

- (IBAction)resolutionCh1DropDownListTap:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [_prescalarCh0DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh0DropDownList.hidden    = YES;
    
    [_prescalarCh1DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh1DropDownList.hidden    = YES;
    
    [_resolutionCh0DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh0DropdownList.hidden   = YES;
    
    [_resolutionCh1DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh1DropdownList.hidden   = NO;
}

- (IBAction)resolutionCh16bitOptionSelected:(id)sender {
    _resolutionCh1DropDownTitle.text  = str_6_bit;
    _resolutionCh1DropdownList.hidden = true;
}

- (IBAction)resolutionCh18bitOptionSelected:(id)sender {
    _resolutionCh1DropDownTitle.text  = str_8_bit;
    _resolutionCh1DropdownList.hidden = true;
}

- (IBAction)resolutionCh110bitOptionSelected:(id)sender {
    _resolutionCh1DropDownTitle.text  = str_10_bit;
    _resolutionCh1DropdownList.hidden = true;
}

- (IBAction)resolutionCh112bitOptionSelected:(id)sender {
    _resolutionCh1DropDownTitle.text  = str_12_bit;
    _resolutionCh1DropdownList.hidden = true;
}

- (IBAction)prescaleCh100bitOptionSelected:(id)sender {
    _prescalarConfigCh1DropDownTitle.text = str_00b;
    _prescalarCh1DropDownList.hidden      = true;
}

- (IBAction)prescaleCh101bitOptionSelected:(id)sender {
    _prescalarConfigCh1DropDownTitle.text = str_01b;
    _prescalarCh1DropDownList.hidden      = true;
}

- (IBAction)prescaleCh110bitOptionSelected:(id)sender {
    _prescalarConfigCh1DropDownTitle.text = str_10b;
    _prescalarCh1DropDownList.hidden      = true;
}
- (IBAction)prescaleCh111bitOptionSelected:(id)sender {
    _prescalarConfigCh1DropDownTitle.text = str_11b;
    _prescalarCh1DropDownList.hidden      = true;
}

- (IBAction)prescalarCh1DropDownListTap:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [_prescalarCh0DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh0DropDownList.hidden    = YES;
    
    [_prescalarCh1DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh1DropDownList.hidden    = NO;
    
    [_resolutionCh0DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh0DropdownList.hidden   = YES;
    
    [_resolutionCh1DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh1DropdownList.hidden   = YES;
}

- (IBAction)navBarButtonClick:(id)sender {
    CATransition *animation             = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    
    if (_configDropDownList.hidden == false)
        _configDropDownList.hidden      = true;
    else
        _configDropDownList.hidden      = false;
    
    [_prescalarCh0DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh0DropDownList.hidden    = YES;
    
    [_prescalarCh1DropDownList.layer addAnimation:animation forKey:nil];
    _prescalarCh1DropDownList.hidden    = YES;
    
    [_resolutionCh0DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh0DropdownList.hidden   = YES;
    
    [_resolutionCh1DropdownList.layer addAnimation:animation forKey:nil];
    _resolutionCh1DropdownList.hidden   = YES;
}

@end
